---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-Test Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/ci/compare_test_reports_service.rb` (行5-6, 9-10, 13-15, 17-22, 25-29)
- E-02: `app/services/ci/compare_reports_base_service.rb` (行10-11, 13-14, 16, 18-25)
- E-03: `app/serializers/test_reports_comparer_serializer.rb`
- E-04: `app/serializers/test_reports_comparer_entity.rb` (行3-14)
- E-05: `app/models/ci/pipeline.rb` (行1332-1338)
- E-06: 帳票一覧.csv (No.16の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JSON出力形式 | E-02 (行20-25) | ○ |
| C-02 | comparer_classはTestReportsComparer | E-01 (行5-6) | ○ |
| C-03 | serializer_classはTestReportsComparerSerializer | E-01 (行9-10) | ○ |
| C-04 | get_reportでpipeline.test_reports取得 | E-01 (行13-15) | ○ |
| C-05 | TestFailureHistoryを読み込む | E-01 (行17-22) | ○ |
| C-06 | failed_test_casesを収集 | E-01 (行25-29) | ○ |
| C-07 | base_pipeline実行中ならparsing返却 | E-02 (行10-11) | ○ |
| C-08 | レポートがparsing中ならparsing返却 | E-02 (行16) | ○ |
| C-09 | comparerを生成してシリアライズ | E-02 (行18-25) | ○ |
| C-10 | ParserErrorをキャッチしてerror返却 | E-02 (行27-32) | ○ |
| C-11 | total_statusを公開 | E-04 (行4) | ○ |
| C-12 | summaryにtotal/resolved/failed/erroredを公開 | E-04 (行6-11) | ○ |
| C-13 | suite_comparersを公開 | E-04 (行13) | ○ |
| C-14 | pipeline.test_reportsでTestReport生成 | E-05 (行1332-1333) | ○ |
| C-15 | collect_test_reports!で結果収集 | E-05 (行1334-1336) | ○ |
| C-16 | latest_test_report_buildsから取得 | E-05 (行1334) | ○ |
| C-17 | new_failuresを公開 | E-01, E-04 (構造) | ○ |
| C-18 | resolved_failuresを公開 | E-01, E-04 (構造) | ○ |
| C-19 | existing_failuresを公開 | E-01, E-04 (構造) | ○ |
| C-20 | status: parsed/parsing/error | E-02 (行20-32) | ○ |
| C-21 | keyにpipeline_id, updated_atを含む | E-02 (行54-59) | ○ |
| C-22 | latest?メソッドでキャッシュ有効性確認 | E-02 (行35-37) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠あり、コードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] MRのテストレポートウィジェットが表示されることを確認
- [ ] パイプライン実行中にparsing状態が返却されることを確認
- [ ] new_failures/resolved_failures/existing_failuresが正しく分類されることを確認
- [ ] summaryの数値が正しく計算されることを確認
- [ ] TestFailureHistoryで失敗履歴が読み込まれることを確認
